#ifndef OURDREAM_2D_INPUTSYSTEM_WIN32_H
#define OURDREAM_2D_INPUTSYSTEM_WIN32_H

#include "IInterface.h"
#include "ComDef.h"
#include "RenderSystem.h"
#include <windows.h>

// ¼ṹ
struct SOD2DInputEvent
{
	int		type;
	int		key;
	int		flags;
	int		chr;
	int		wheel;
	float	x;
	float	y;
};

// ¼
#define INPUT_KEYDOWN		1
#define INPUT_KEYUP			2
#define INPUT_MBUTTONDOWN	3
#define INPUT_MBUTTONUP		4
#define INPUT_MOUSEMOVE		5
#define INPUT_MOUSEWHEEL	6

// 帽¼
#define ODEINP_SHIFT		1
#define ODEINP_CTRL			2
#define ODEINP_ALT			4
#define ODEINP_CAPSLOCK		8
#define ODEINP_SCROLLLOCK	16
#define ODEINP_NUMLOCK		32
#define ODEINP_REPEAT		64


class IInputSystem_Win32 : public IInterface
{
public:
	virtual bool CALL Initialize(IRenderSystem * render, SOD2DSystemSetup setup)=0;

	virtual void CALL GetMousePos(float *x, float *y)=0;
	virtual void CALL SetMousePos(float x, float y)=0;
	virtual int	 CALL GetMouseWheel(void)=0;
	virtual bool CALL IsMouseOver(void)=0;
	virtual bool CALL KeyDown(int key)=0;
	virtual bool CALL KeyUp(int key)=0;
	virtual bool CALL GetTheKeyState(int key)=0;
	virtual LPSTR CALL GetKeyName(int key)=0;
	virtual int	 CALL GetInputKey(void)=0;
	virtual int	 CALL GetInputChar(void)=0;
	virtual bool CALL GetInputEvent(SOD2DInputEvent *event)=0;
	virtual void CALL ClearInputEvent(void)=0;
	
	virtual void CALL Release(void)=0;
	
};


// 
#define OD2DWK_LBUTTON		0x01
#define OD2DWK_RBUTTON		0x02
#define OD2DWK_MBUTTON		0x04

#define OD2DWK_ESCAPE		0x1B
#define OD2DWK_BACKSPACE	0x08
#define OD2DWK_TAB			0x09
#define OD2DWK_ENTER		0x0D
#define OD2DWK_SPACE		0x20

#define OD2DWK_SHIFT		0x10
#define OD2DWK_CTRL			0x11
#define OD2DWK_ALT			0x12

#define OD2DWK_LWIN			0x5B
#define OD2DWK_RWIN			0x5C
#define OD2DWK_APPS			0x5D

#define OD2DWK_PAUSE		0x13
#define OD2DWK_CAPSLOCK		0x14
#define OD2DWK_NUMLOCK		0x90
#define OD2DWK_SCROLLLOCK	0x91

#define OD2DWK_PGUP			0x21
#define OD2DWK_PGDN			0x22
#define OD2DWK_HOME			0x24
#define OD2DWK_END			0x23
#define OD2DWK_INSERT		0x2D
#define OD2DWK_DELETE		0x2E

#define OD2DWK_LEFT			0x25
#define OD2DWK_UP			0x26
#define OD2DWK_RIGHT		0x27
#define OD2DWK_DOWN			0x28

#define OD2DWK_0			0x30
#define OD2DWK_1			0x31
#define OD2DWK_2			0x32
#define OD2DWK_3			0x33
#define OD2DWK_4			0x34
#define OD2DWK_5			0x35
#define OD2DWK_6			0x36
#define OD2DWK_7			0x37
#define OD2DWK_8			0x38
#define OD2DWK_9			0x39

#define OD2DWK_A			0x41
#define OD2DWK_B			0x42
#define OD2DWK_C			0x43
#define OD2DWK_D			0x44
#define OD2DWK_E			0x45
#define OD2DWK_F			0x46
#define OD2DWK_G			0x47
#define OD2DWK_H			0x48
#define OD2DWK_I			0x49
#define OD2DWK_J			0x4A
#define OD2DWK_K			0x4B
#define OD2DWK_L			0x4C
#define OD2DWK_M			0x4D
#define OD2DWK_N			0x4E
#define OD2DWK_O			0x4F
#define OD2DWK_P			0x50
#define OD2DWK_Q			0x51
#define OD2DWK_R			0x52
#define OD2DWK_S			0x53
#define OD2DWK_T			0x54
#define OD2DWK_U			0x55
#define OD2DWK_V			0x56
#define OD2DWK_W			0x57
#define OD2DWK_X			0x58
#define OD2DWK_Y			0x59
#define OD2DWK_Z			0x5A

#define OD2DWK_GRAVE		0xC0
#define OD2DWK_MINUS		0xBD
#define OD2DWK_EQUALS		0xBB
#define OD2DWK_BACKSLASH	0xDC
#define OD2DWK_LBRACKET		0xDB
#define OD2DWK_RBRACKET		0xDD
#define OD2DWK_SEMICOLON	0xBA
#define OD2DWK_APOSTROPHE	0xDE
#define OD2DWK_COMMA		0xBC
#define OD2DWK_PERIOD		0xBE
#define OD2DWK_SLASH		0xBF

#define OD2DWK_NUMPAD0		0x60
#define OD2DWK_NUMPAD1		0x61
#define OD2DWK_NUMPAD2		0x62
#define OD2DWK_NUMPAD3		0x63
#define OD2DWK_NUMPAD4		0x64
#define OD2DWK_NUMPAD5		0x65
#define OD2DWK_NUMPAD6		0x66
#define OD2DWK_NUMPAD7		0x67
#define OD2DWK_NUMPAD8		0x68
#define OD2DWK_NUMPAD9		0x69

#define OD2DWK_MULTIPLY		0x6A
#define OD2DWK_DIVIDE		0x6F
#define OD2DWK_ADD			0x6B
#define OD2DWK_SUBTRACT		0x6D
#define OD2DWK_DECIMAL		0x6E

#define OD2DWK_F1			0x70
#define OD2DWK_F2			0x71
#define OD2DWK_F3			0x72
#define OD2DWK_F4			0x73
#define OD2DWK_F5			0x74
#define OD2DWK_F6			0x75
#define OD2DWK_F7			0x76
#define OD2DWK_F8			0x77
#define OD2DWK_F9			0x78
#define OD2DWK_F10			0x79
#define OD2DWK_F11			0x7A
#define OD2DWK_F12			0x7B

#endif